import matplotlib.pyplot as plt
import numpy as np

def polar():

	theta = np.linspace(0.0, 2*np.pi, 4, endpoint=False)
	radii = [0.425, 0.512, 1.00, 0.818]

	ax = plt.subplot(projection='polar')
	ax.bar(theta, radii, bottom=0, width = np.pi/6)

	plt.savefig('polar.pdf', format='pdf')
	plt.show()

def bar():

	data = [0, 0.11, 0.33, 0.56]
	fig, ax = plt.subplots(figsize=(3,3))
	ax.bar([1,2,3,4], data, width=0.45)
	plt.savefig('4.pdf', format='pdf')
	plt.show()

polar()
